<?php
 
include_once 'conexao.php';

class ModeloHabilidade
{ 
        
	static public function mdlAddHabilidade($dados){ 
 
		$stmt = Conexao::conectar()->prepare("INSERT INTO habilidade
		(descricao, nivel, dataCadastro,idUsuario) VALUES 
	  (:descricao, :nivel, :dataCadastro, :idUsuario)");
		$data = date("d-m-Y H:i:s");
		$stmt->bindParam(":descricao", $dados["descricao"], PDO::PARAM_STR);
		$stmt->bindParam(":nivel", $dados["nivel"], PDO::PARAM_STR);
		$stmt->bindParam(":dataCadastro", $data, PDO::PARAM_STR);
		$stmt->bindParam(":idUsuario", $_SESSION['ID_usuario'], PDO::PARAM_STR);

		if($stmt->execute()){

			return "ok"; 

		}else{

			$errorInfo = $stmt->errorInfo();
  			return $errorInfo[2];
		
		}

	}



	static public function mdlVerificarSeHabilidadeJaExiste($descricao,$idUsuario){

		$resultado = array();

			$stmt = Conexao::conectar()->prepare("SELECT * FROM habilidade where descricao = :descricao and idUsuario = :idUsuario");
			$stmt->bindParam(":descricao", $descricao, PDO::PARAM_STR);
			$stmt->bindParam(":idUsuario", $idUsuario, PDO::PARAM_STR);
			$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;
 
	} 

	static public function mdlMostrarHabilidadesPorIdUsuario($idUsuario){

		$resultado = array();

			$stmt = Conexao::conectar()->prepare("SELECT * FROM habilidade where idUsuario = :idUsuario");
			$stmt->bindParam(":idUsuario", $idUsuario, PDO::PARAM_STR);
			$stmt ->execute(); 

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;
 
	}

	


}


  ?>